/*
 * Decompiled with CFR 0.152.
 */
package com.kenai.jaffl.util;

import com.kenai.jaffl.Platform;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CodingErrorAction;

public final class BufferUtil {
    private BufferUtil() {
    }

    public static final void putString(ByteBuffer byteBuffer, Charset charset, String string) {
        BufferUtil.putCharSequence(byteBuffer, charset, (CharSequence)string);
    }

    public static final String getString(ByteBuffer byteBuffer, Charset charset) {
        return ((Object)BufferUtil.getCharSequence(byteBuffer, charset)).toString();
    }

    public static final void putCharSequence(ByteBuffer byteBuffer, Charset charset, CharSequence charSequence) {
        BufferUtil.putCharSequence(byteBuffer, charset.newEncoder(), charSequence);
    }

    public static final void putCharSequence(ByteBuffer byteBuffer, CharsetEncoder charsetEncoder, CharSequence charSequence) {
        charsetEncoder.reset().onMalformedInput(CodingErrorAction.REPLACE).onUnmappableCharacter(CodingErrorAction.REPLACE).encode(CharBuffer.wrap(charSequence), byteBuffer, true);
        charsetEncoder.flush(byteBuffer);
        int n = Math.round(charsetEncoder.maxBytesPerChar());
        if (n == 4) {
            byteBuffer.putInt(0);
        } else if (n == 2) {
            byteBuffer.putShort((short)0);
        } else if (n == 1) {
            byteBuffer.put((byte)0);
        }
    }

    public static final CharSequence getCharSequence(ByteBuffer byteBuffer, Charset charset) {
        return BufferUtil.getCharSequence(byteBuffer, charset.newDecoder());
    }

    public static final CharSequence getCharSequence(ByteBuffer byteBuffer, CharsetDecoder charsetDecoder) {
        ByteBuffer byteBuffer2 = byteBuffer.slice();
        int n = BufferUtil.indexOf(byteBuffer2, (byte)0);
        if (n < 0) {
            n = byteBuffer2.limit();
        }
        byteBuffer2.position(0).limit(n);
        try {
            return charsetDecoder.reset().onMalformedInput(CodingErrorAction.REPLACE).onUnmappableCharacter(CodingErrorAction.REPLACE).decode(byteBuffer2);
        }
        catch (CharacterCodingException characterCodingException) {
            throw new Error("Illegal character data in native string", characterCodingException);
        }
    }

    public static final int positionOf(ByteBuffer byteBuffer, byte by) {
        if (byteBuffer.hasArray()) {
            byte[] byArray = byteBuffer.array();
            int n = byteBuffer.arrayOffset();
            int n2 = byteBuffer.limit();
            for (int i = byteBuffer.position(); i < n2; ++i) {
                if (byArray[n + i] != by) continue;
                return i;
            }
        } else {
            int n = byteBuffer.limit();
            for (int i = byteBuffer.position(); i < n; ++i) {
                if (byteBuffer.get(i) != by) continue;
                return i;
            }
        }
        return -1;
    }

    public static final int indexOf(ByteBuffer byteBuffer, byte by) {
        if (byteBuffer.hasArray()) {
            byte[] byArray = byteBuffer.array();
            int n = byteBuffer.arrayOffset() + byteBuffer.position();
            int n2 = n + byteBuffer.limit();
            for (int i = 0; i < n2 && i > -1; ++i) {
                if (byArray[n + i] != by) continue;
                return i;
            }
        } else {
            int n = byteBuffer.position();
            for (int i = 0; i < byteBuffer.limit(); ++i) {
                if (byteBuffer.get(n + i) != by) continue;
                return i;
            }
        }
        return -1;
    }

    public static final long getAddress(ByteBuffer byteBuffer, int n) {
        return AddressIO.INSTANCE.getAddress(byteBuffer, n);
    }

    public static final void putAddress(ByteBuffer byteBuffer, int n, long l) {
        AddressIO.INSTANCE.putAddress(byteBuffer, n, l);
    }

    public static ByteBuffer slice(ByteBuffer byteBuffer, int n) {
        ByteBuffer byteBuffer2 = byteBuffer.duplicate();
        byteBuffer2.position(n);
        return byteBuffer2.slice();
    }

    public static ByteBuffer slice(ByteBuffer byteBuffer, int n, int n2) {
        ByteBuffer byteBuffer2 = byteBuffer.duplicate();
        byteBuffer2.position(n).limit(n + n2);
        return byteBuffer2.slice();
    }

    private static interface AddressIO {
        public static final AddressIO INSTANCE = Platform.getPlatform().addressSize() == 32 ? AddressIO32.IMPL : AddressIO64.IMPL;

        public long getAddress(ByteBuffer var1, int var2);

        public void putAddress(ByteBuffer var1, int var2, long var3);

        public static class AddressIO32
        implements AddressIO {
            public static final AddressIO IMPL = new AddressIO32();

            public long getAddress(ByteBuffer byteBuffer, int n) {
                return byteBuffer.getInt(n);
            }

            public void putAddress(ByteBuffer byteBuffer, int n, long l) {
                byteBuffer.putInt(n, (int)l);
            }
        }

        public static class AddressIO64
        implements AddressIO {
            public static final AddressIO IMPL = new AddressIO64();

            public long getAddress(ByteBuffer byteBuffer, int n) {
                return byteBuffer.getLong(n);
            }

            public void putAddress(ByteBuffer byteBuffer, int n, long l) {
                byteBuffer.putLong(n, l);
            }
        }
    }
}

